/*
 * Decompiled with CFR 0.152.
 */
public enum EnumDirection {
    UP(0, 1, 0),
    DOWN(0, -1, 0),
    SOUTH(0, 0, 1),
    NORTH(0, 0, -1),
    EAST(1, 0, 0),
    WEST(-1, 0, 0);

    final int dx;
    final int dy;
    final int dz;

    private EnumDirection(int dx2, int dy2, int dz2) {
        this.dx = dx2;
        this.dy = dy2;
        this.dz = dz2;
    }

    static EnumDirection get(int ordinal) {
        return EnumDirection.values()[ordinal];
    }

    static EnumDirection getDirectionFromYaw(float yaw) {
        int direction = ls.c((double)(yaw * 4.0f / 360.0f) + 0.5) & 3;
        if (direction == 0) {
            return SOUTH;
        }
        if (direction == 1) {
            return WEST;
        }
        if (direction == 2) {
            return NORTH;
        }
        if (direction == 3) {
            return EAST;
        }
        atv.setErrorMessage("getDirectionFromYaw: invalid result");
        return null;
    }

    static float getNormalizedYaw(float yaw) {
        while (yaw < 0.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 360.0f) {
            yaw -= 360.0f;
        }
        return yaw;
    }

    static boolean doesYawHaveNorthComponent(float yaw) {
        return (yaw = EnumDirection.getNormalizedYaw(yaw)) > 90.0f && yaw < 270.0f;
    }

    static boolean doesYawHaveSouthComponent(float yaw) {
        return (yaw = EnumDirection.getNormalizedYaw(yaw)) > 270.0f || yaw < 90.0f;
    }

    static boolean doesYawHaveWestComponent(float yaw) {
        return (yaw = EnumDirection.getNormalizedYaw(yaw)) > 0.0f && yaw < 180.0f;
    }

    static boolean doesYawHaveEastComponent(float yaw) {
        return (yaw = EnumDirection.getNormalizedYaw(yaw)) > 180.0f && yaw < 360.0f;
    }

    public static EnumDirection getDirectionFromPitch(float pitch) {
        return pitch < 0.0f ? UP : DOWN;
    }

    final boolean isUp() {
        return this == UP;
    }

    final boolean isDown() {
        return this == DOWN;
    }

    final boolean isSouth() {
        return this == SOUTH;
    }

    final boolean isNorth() {
        return this == NORTH;
    }

    final boolean isEast() {
        return this == EAST;
    }

    final boolean isWest() {
        return this == WEST;
    }

    final boolean isUpOrDown() {
        return this == UP || this == DOWN;
    }

    final boolean isHorizontal() {
        return this == SOUTH || this == NORTH || this == EAST || this == WEST;
    }

    final boolean isNorthOrSouth() {
        return this == NORTH || this == SOUTH;
    }

    final boolean isEastOrWest() {
        return this == EAST || this == WEST;
    }

    final EnumDirection getOpposite() {
        if (this == UP) {
            return DOWN;
        }
        if (this == DOWN) {
            return UP;
        }
        if (this == SOUTH) {
            return NORTH;
        }
        if (this == NORTH) {
            return SOUTH;
        }
        if (this == EAST) {
            return WEST;
        }
        return EAST;
    }

    final EnumFace getFace() {
        if (this == UP) {
            return EnumFace.TOP;
        }
        if (this == DOWN) {
            return EnumFace.BOTTOM;
        }
        if (this == SOUTH) {
            return EnumFace.SOUTH;
        }
        if (this == NORTH) {
            return EnumFace.NORTH;
        }
        if (this == EAST) {
            return EnumFace.EAST;
        }
        return EnumFace.WEST;
    }

    final EnumFace getOppositeFace() {
        if (this == UP) {
            return EnumFace.BOTTOM;
        }
        if (this == DOWN) {
            return EnumFace.TOP;
        }
        if (this == SOUTH) {
            return EnumFace.NORTH;
        }
        if (this == NORTH) {
            return EnumFace.SOUTH;
        }
        if (this == EAST) {
            return EnumFace.WEST;
        }
        return EnumFace.EAST;
    }

    public final int getNeighborX(int x2) {
        return this == WEST ? x2 - 1 : (this == EAST ? x2 + 1 : x2);
    }

    public final int getNeighborY(int y2) {
        return this == DOWN ? y2 - 1 : (this == UP ? y2 + 1 : y2);
    }

    public final int getNeighborZ(int z2) {
        return this == NORTH ? z2 - 1 : (this == SOUTH ? z2 + 1 : z2);
    }

    public final EnumDirection adjustForCoordBaseMode(int coord_base_mode) {
        if (coord_base_mode == 0) {
            return this.isNorthOrSouth() ? this.getOpposite() : this;
        }
        if (coord_base_mode == 1) {
            return this.isNorth() ? WEST : (this.isSouth() ? EAST : (this.isWest() ? NORTH : (this.isEast() ? SOUTH : this)));
        }
        if (coord_base_mode == 2) {
            return this;
        }
        if (coord_base_mode == 3) {
            return this.isNorth() ? EAST : (this.isSouth() ? WEST : (this.isWest() ? NORTH : (this.isEast() ? SOUTH : this)));
        }
        atv.setErrorMessage("adjustForCoordBaseMode: invalid coord_base_mode " + coord_base_mode);
        return this;
    }

    public String getDescriptor(boolean capitalized) {
        return capitalized ? StringHelper.capitalize(this.name().toLowerCase()) : this.name().toLowerCase();
    }

    boolean isAlignedWith(Axis axis) {
        return this.isUpOrDown() ? axis.isUpDown() : (this.isNorthOrSouth() ? axis.isNorthSouth() : axis.isEastWest());
    }
}

